/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomRegisters;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.entity.EntityNPCInterface;

public class VisibilityController {
    public static final Map<String, EntityNPCInterface> trackedEntityHashTable = new HashMap<String, EntityNPCInterface>();
    public static final Map<EntityPlayerMP, List<EntityNPCInterface>> invisibleNPCsTable = new HashMap<EntityPlayerMP, List<EntityNPCInterface>>();

    public void checkIsVisible(EntityNPCInterface npc, EntityPlayerMP playerMP) {
        boolean isVisible;
        if (!CustomNpcs.EnableInvisibleNpcs) {
            return;
        }
        boolean bl = isVisible = playerMP.field_71075_bZ.field_75098_d || playerMP.func_184614_ca().func_77973_b() == CustomRegisters.wand || npc.display.isVisibleTo(playerMP);
        if (!invisibleNPCsTable.containsKey(playerMP)) {
            invisibleNPCsTable.put(playerMP, new ArrayList());
        }
        if (isVisible && invisibleNPCsTable.get(playerMP).contains((Object)npc)) {
            EntityRegistry.EntityRegistration er;
            if (invisibleNPCsTable.get(playerMP).remove((Object)npc) && (er = EntityRegistry.instance().lookupModSpawn(((Object)((Object)npc)).getClass(), false)) != null) {
                FMLMessage.EntitySpawnMessage message = new FMLMessage.EntitySpawnMessage(er, (Entity)npc, er.getContainer());
                Server.sendData(playerMP, EnumPacketClient.VISIBLE_TRUE, npc.func_110124_au(), npc.func_145782_y(), message);
            }
        } else if (!isVisible && !invisibleNPCsTable.get(playerMP).contains((Object)npc)) {
            invisibleNPCsTable.get(playerMP).add(npc);
            Server.sendData(playerMP, EnumPacketClient.VISIBLE_FALSE, npc.func_110124_au(), npc.func_145782_y());
        }
    }

    public void onUpdate(EntityPlayerMP playerMP) {
        if (!CustomNpcs.EnableInvisibleNpcs) {
            return;
        }
        if (!invisibleNPCsTable.containsKey(playerMP)) {
            invisibleNPCsTable.put(playerMP, new ArrayList());
        }
        EntityNPCInterface npc = null;
        try {
            ArrayList<String> del = new ArrayList<String>();
            HashSet<String> set = new HashSet<String>(trackedEntityHashTable.keySet());
            for (String key : set) {
                npc = trackedEntityHashTable.get(key);
                if (npc == null || npc.field_70170_p == null || npc.field_70170_p.func_73045_a(npc.func_145782_y()) == null) {
                    if (npc == null) continue;
                    del.add(key);
                    continue;
                }
                if (playerMP.field_70170_p == null || npc.field_70170_p.field_73011_w.getDimension() != playerMP.field_70170_p.field_73011_w.getDimension() || npc.display.getVisible() != 1) continue;
                this.checkIsVisible(npc, playerMP);
            }
            for (String npcName : del) {
                trackedEntityHashTable.remove(npcName);
            }
        }
        catch (Exception e) {
            LogWriter.debug("CNPCs: npc: " + npc);
            LogWriter.debug("CNPCs: npc.world: " + (npc != null ? npc.field_70170_p : "n/a"));
            LogWriter.debug("CNPCs: npc.getEntityId(): " + (npc != null ? Integer.valueOf(npc.func_145782_y()) : "n/a"));
            LogWriter.error(e);
        }
    }

    public void trackNpc(EntityNPCInterface npc) {
        if (npc == null || npc.field_70170_p == null) {
            return;
        }
        String key = npc.field_70170_p.field_73011_w.getDimension() + "_" + npc.func_110124_au();
        if (trackedEntityHashTable.containsKey(key)) {
            return;
        }
        trackedEntityHashTable.put(key, npc);
    }
}

